<?php
session_start();
include 'conexion.php';

if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$search_query = '';
if (isset($_GET['search'])) {
    $search_query = $_GET['search'];
}

// Obtener propietarios con filtro de búsqueda
$sql = "SELECT p.id_propietario, u.id_usuario, u.nombre, u.rut, u.email, p.numero_departamento, p.celular, u.estado 
        FROM propietarios p 
        JOIN usuarios u ON p.id_usuario = u.id_usuario 
        WHERE u.nombre LIKE ? OR u.rut LIKE ? OR u.email LIKE ?";
$stmt = $conn->prepare($sql);
$search_term = "%" . $search_query . "%";
$stmt->bind_param("sss", $search_term, $search_term, $search_term);
$stmt->execute();
$result_propietarios = $stmt->get_result();

// Eliminar usuario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['eliminar'])) {
    $id_usuario = $_POST['id_usuario'];

    $stmt = $conn->prepare("DELETE FROM usuarios WHERE id_usuario = ?");
    $stmt->bind_param("i", $id_usuario);

    if ($stmt->execute()) {
        $_SESSION['mensaje'] = "Usuario eliminado con éxito.";
    } else {
        $_SESSION['mensaje'] = "Error al eliminar usuario: " . $stmt->error;
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Bloquear propietario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bloquear'])) {
    $id_usuario = $_POST['id_usuario'];

    $stmt = $conn->prepare("UPDATE usuarios SET estado = 'bloqueado' WHERE id_usuario = ?");
    $stmt->bind_param("i", $id_usuario);

    if ($stmt->execute()) {
        $_SESSION['mensaje'] = "Propietario bloqueado con éxito.";
    } else {
        $_SESSION['mensaje'] = "Error al bloquear: " . $stmt->error;
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Desbloquear propietario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['desbloquear'])) {
    $id_usuario = $_POST['id_usuario'];

    $stmt = $conn->prepare("UPDATE usuarios SET estado = 'activo' WHERE id_usuario = ?");
    $stmt->bind_param("i", $id_usuario);

    if ($stmt->execute()) {
        $_SESSION['mensaje'] = "Propietario desbloqueado con éxito.";
    } else {
        $_SESSION['mensaje'] = "Error al desbloquear: " . $stmt->error;
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Resetear contraseña
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reset_password'])) {
    $id_usuario = $_POST['id_usuario'];
    $new_password = password_hash('123456', PASSWORD_BCRYPT); // Contraseña por defecto

    $stmt = $conn->prepare("UPDATE usuarios SET password = ? WHERE id_usuario = ?");
    if ($stmt) {
        $stmt->bind_param("si", $new_password, $id_usuario);
        if ($stmt->execute()) {
            $_SESSION['mensaje'] = "Contraseña reseteada con éxito. La nueva contraseña es '123456'.";
        } else {
            $_SESSION['mensaje'] = "Error al resetear contraseña: " . $stmt->error;
        }
    } else {
        $_SESSION['mensaje'] = "Error al preparar la consulta de reset: " . $conn->error;
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
$sql = "SELECT * FROM usuarios WHERE rol = 'conserje' AND (nombre LIKE ? OR rut LIKE ? OR email LIKE ?)";


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Administrador</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <!-- Botón para ocultar/mostrar el sidebar -->
                <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
        </ul>
        <ul class="navbar-nav ml-auto">
            <li class="nav-item">
                <a class="nav-link" href="login.php" role="button">
                    <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
                </a>
            </li>
        </ul>
    </nav>
    <!-- Sidebar -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <a href="#" class="brand-link">
            <span class="brand-text font-weight-light">Sistema Arriendos</span>
        </a>
        <div class="sidebar">
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="info">
                    <a href="#" class="d-block">Administrador</a>
                </div>
            </div>
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
                    <li class="nav-item">
                        <a href="admin_dashboard.php" class="nav-link active">
                            <i class="nav-icon fas fa-home"></i>
                            <p>Dashboard</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="registrar_propietario.php" class="nav-link">
                            <i class="nav-icon fas fa-user-plus"></i>
                            <p>Registrar Propietario</p>
                        </a>
                    </li>
                    <li class="nav-item">
    <a href="crear_conserje.php" class="nav-link">
        <i class="nav-icon fas fa-user-shield"></i>
        <p>Crear Conserje</p>
    </a>
</li>
<li class="nav-item">
    <a href="ingresar_lista_negra.php" class="nav-link">
        <i class="nav-icon fas fa-ban"></i>
        <p>Ingresar a Lista Negra</p>
    </a>
</li>
<li class="nav-item">
    <a href="listar_lista_negra.php" class="nav-link">
        <i class="nav-icon fas fa-ban"></i>
        <p>Ver Lista Negra</p>
    </a>
</li>
<li class="nav-item">
    <a href="listar_conserjes.php" class="nav-link">
        <i class="nav-icon fas fa-users"></i>
        <p>Ver Conserjes</p>
    </a>
</li>
	


                    <li class="nav-item">
                        <a href="vista_propietarios.php" class="nav-link">
                            <i class="nav-icon fas fa-eye"></i>
                            <p>Ver Propietarios</p>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </aside>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Dashboard Administrador</h1>
                    </div>
                    <div class="col-sm-6">
                        <form method="GET" action="" class="d-flex justify-content-end">
                            <input type="text" name="search" class="form-control w-50 me-2" placeholder="Buscar por nombre, RUT o email" value="<?php echo $search_query; ?>">
                            <button type="submit" class="btn btn-primary">Buscar</button>
                        </form>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if (isset($_SESSION['mensaje'])): ?>
                    <div class="alert alert-info">
                        <?php
                        echo $_SESSION['mensaje'];
                        unset($_SESSION['mensaje']);
                        ?>
                    </div>
                <?php endif; ?>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>RUT</th>
                            <th>Email</th>
                            <th>Departamento</th>
                            <th>Celular</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result_propietarios->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['nombre']; ?></td>
                                <td><?php echo $row['rut']; ?></td>
                                <td><?php echo $row['email']; ?></td>
                                <td><?php echo $row['numero_departamento']; ?></td>
                                <td><?php echo $row['celular']; ?></td>
                                <td><?php echo ucfirst($row['estado']); ?></td>
                                <td>
                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="id_usuario" value="<?php echo $row['id_usuario']; ?>">
                                        <?php if ($row['estado'] === 'activo'): ?>
                                            <button type="submit" name="bloquear" class="btn btn-danger btn-sm">Bloquear</button>
                                        <?php else: ?>
                                            <button type="submit" name="desbloquear" class="btn btn-success btn-sm">Desbloquear</button>
                                        <?php endif; ?>
                                        <button type="submit" name="reset_password" class="btn btn-warning btn-sm">Reset Pass</button>
                                        <button type="submit" name="eliminar" class="btn btn-danger btn-sm">Eliminar</button>
                                    </form>
                                    <a href="editar_propietario.php?id=<?php echo $row['id_propietario']; ?>" class="btn btn-warning btn-sm">Editar</a>
                                </td>
                            </tr>

                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </section>
    </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

