<?php
session_start();
include 'conexion.php';

// Verificar si el usuario tiene rol de administrador
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
    header("Location: login.php");
    exit;
}

// Verificar si se proporcionó el ID del conserje
if (!isset($_GET['id'])) {
    header("Location: listar_conserjes.php");
    exit;
}

$id_usuario = $_GET['id'];

// Obtener datos del conserje
$stmt = $conn->prepare("SELECT * FROM usuarios WHERE id_usuario = ? AND rol = 'conserje'");
$stmt->bind_param("i", $id_usuario);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows !== 1) {
    header("Location: listar_conserjes.php");
    exit;
}

$conserje = $result->fetch_assoc();

// Actualizar datos del conserje
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $email = $_POST['email'];
    $estado = $_POST['estado'];

    $stmt_update = $conn->prepare("UPDATE usuarios SET nombre = ?, email = ?, estado = ? WHERE id_usuario = ?");
    $stmt_update->bind_param("sssi", $nombre, $email, $estado, $id_usuario);

    if ($stmt_update->execute()) {
        $_SESSION['mensaje'] = "Conserje actualizado con éxito.";
        header("Location: listar_conserjes.php");
        exit;
    } else {
        $error = "Error al actualizar conserje: " . $stmt_update->error;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Conserje</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h1 class="mb-4">Editar Conserje</h1>

    <?php if (isset($error)): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo htmlspecialchars($conserje['nombre']); ?>" required>
        </div>
        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($conserje['email']); ?>" required>
        </div>
        <div class="mb-3">
            <label for="estado" class="form-label">Estado</label>
            <select class="form-control" id="estado" name="estado">
                <option value="activo" <?php echo $conserje['estado'] === 'activo' ? 'selected' : ''; ?>>Activo</option>
                <option value="bloqueado" <?php echo $conserje['estado'] === 'bloqueado' ? 'selected' : ''; ?>>Bloqueado</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Guardar Cambios</button>
        <a href="listar_conserjes.php" class="btn btn-secondary">Cancelar</a>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
