<?php
session_start();
include 'conexion.php';

// Verificar si el usuario ha iniciado sesión y tiene el rol correcto
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'propietario') {
    header("Location: login.php");
    exit;
}

// Verificar que el ID esté presente en la URL
if (isset($_GET['id'])) {
    $id_arrendatario = intval($_GET['id']); // Asegurarse de que sea un número entero

    // Eliminar los acompañantes asociados al arrendatario
    $stmt1 = $conn->prepare("DELETE FROM acompanantes WHERE id_arrendatario = ?");
    $stmt1->bind_param("i", $id_arrendatario);
    $stmt1->execute();

    // Eliminar el arrendatario
    $stmt2 = $conn->prepare("DELETE FROM arrendatarios WHERE id_arrendatario = ?");
    $stmt2->bind_param("i", $id_arrendatario);

    if ($stmt2->execute()) {
        $_SESSION['mensaje'] = "Arrendatario eliminado con éxito.";
    } else {
        $_SESSION['mensaje'] = "Error al eliminar arrendatario: " . $stmt2->error;
    }
} else {
    $_SESSION['mensaje'] = "ID de arrendatario no especificado.";
}

// Redirigir al dashboard del propietario
header("Location: propietario_dashboard.php");
exit;
?>
