<?php
session_start();
include 'conexion.php';

// Verificar si el usuario tiene rol de administrador
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
    header("Location: login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $rut = $_POST['rut'];
    $motivo = $_POST['motivo'];

    // Verificar si el RUT ya está en la lista negra
    $stmt_check = $conn->prepare("SELECT * FROM lista_negra WHERE rut = ?");
    $stmt_check->bind_param("s", $rut);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();

    if ($result_check->num_rows > 0) {
        $error = "El RUT $rut ya está en la lista negra.";
    } else {
        // Insertar en la lista negra
        $stmt = $conn->prepare("INSERT INTO lista_negra (nombre, rut, motivo) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $nombre, $rut, $motivo);

        if ($stmt->execute()) {
            $success = "Usuario añadido a la lista negra con éxito.";
        } else {
            $error = "Error al añadir a la lista negra: " . $stmt->error;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ingresar a Lista Negra</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h1>Ingresar a Lista Negra</h1>

    <?php if (isset($error)): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php elseif (isset($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>

    <form method="POST" action="">
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" class="form-control" id="nombre" name="nombre" required>
        </div>
        <div class="mb-3">
            <label for="rut" class="form-label">RUT</label>
            <input type="text" class="form-control" id="rut" name="rut" required>
        </div>
        <div class="mb-3">
            <label for="motivo" class="form-label">Motivo</label>
            <textarea class="form-control" id="motivo" name="motivo" rows="3" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Añadir a Lista Negra</button>
    </form>
    <a href="admin_dashboard.php" class="btn btn-secondary mt-3">Volver</a>
</div>
</body>
</html>
