<?php
session_start();

// Verificar si el usuario ha iniciado sesión
if (!isset($_SESSION['rol']) || !isset($_SESSION['id_usuario'])) {
    header("Location: login.php?mensaje=no_autorizado");
    exit;
}

// Configurar el tiempo de inactividad permitido (en segundos)
define('TIEMPO_INACTIVIDAD', 300); // 5 minutos

if (isset($_SESSION['ultimo_acceso'])) {
    $tiempo_transcurrido = time() - $_SESSION['ultimo_acceso'];

    if ($tiempo_transcurrido > TIEMPO_INACTIVIDAD) {
        session_unset();
        session_destroy();
        header("Location: login.php?mensaje=inactividad");
        exit;
    }
}

// Actualizar el tiempo del último acceso
$_SESSION['ultimo_acceso'] = time();

// Conexión a la base de datos
include 'conexion.php';

// Verificar si el usuario tiene el rol adecuado
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'propietario') {
    header("Location: login.php");
    exit;
}

$id_usuario = $_SESSION['id_usuario'];

// Obtener el ID del propietario
$stmt = $conn->prepare("SELECT p.id_propietario, p.numero_departamento, p.estacionamiento FROM propietarios p WHERE p.id_usuario = ?");
$stmt->bind_param("i", $id_usuario);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $row = $result->fetch_assoc();
    $id_propietario = $row['id_propietario'];
    $numero_departamento = $row['numero_departamento'];
    $estacionamiento_departamento = $row['estacionamiento'];
} else {
    echo "<div class='alert alert-danger'>Propietario no encontrado.</div>";
    exit;
}

$search_query = '';
if (isset($_GET['search'])) {
    $search_query = $_GET['search'];
}

// Obtener arrendatarios con datos de llegada, salida y conserje
$stmt = $conn->prepare("
    SELECT a.*, 
        DATEDIFF(a.fecha_salida, a.fecha_inicio) AS dias_totales, 
        DATEDIFF(a.fecha_inicio, CURDATE()) AS dias_faltan_inicio,
        DATEDIFF(a.fecha_salida, CURDATE()) AS dias_faltan_fin,
        CASE
            WHEN CURDATE() < a.fecha_inicio THEN 'Pendiente'
            WHEN CURDATE() >= a.fecha_inicio AND CURDATE() <= a.fecha_salida THEN 'En Arriendo'
            ELSE 'Finalizado'
        END AS estado,
        r.fecha_hora_llegada AS llego,
        r.fecha_hora_salida AS salio,
        u.nombre AS conserje
    FROM arrendatarios a
    LEFT JOIN registros r ON a.id_arrendatario = r.id_arrendatario
    LEFT JOIN usuarios u ON r.registrado_por = u.id_usuario
    WHERE a.id_propietario = ? AND (a.nombre LIKE ? OR a.rut LIKE ? OR a.direccion LIKE ?)
    ORDER BY 
        FIELD(
            CASE
                WHEN CURDATE() < a.fecha_inicio THEN 'Pendiente'
                WHEN CURDATE() >= a.fecha_inicio AND CURDATE() <= a.fecha_salida THEN 'En Arriendo'
                ELSE 'Finalizado'
            END, 'En Arriendo', 'Pendiente', 'Finalizado'),
        a.fecha_inicio ASC
");
$search_term = "%" . $search_query . "%";
$stmt->bind_param("isss", $id_propietario, $search_term, $search_term, $search_term);
$stmt->execute();
$result_arrendatarios = $stmt->get_result();
?>

<!DOCTYPE html>

<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Propietario</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">


     <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!--<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">-->
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
        </ul>
        <ul class="navbar-nav ml-auto">
            <li class="nav-item">
                <a class="nav-link" href="login.php" role="button">
                    <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
                </a>
            </li>
        </ul>
    </nav>

    <!-- Sidebar -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <a href="#" class="brand-link">
            <span class="brand-text font-weight-light">Sistema Arriendos</span>
        </a>
        <div class="sidebar">
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="info">
                    <a href="#" class="d-block">Propietario</a>
                </div>
            </div>
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
                    <li class="nav-item">
                        <a href="propietario_dashboard.php" class="nav-link active">
                            <i class="nav-icon fas fa-home"></i>
                            <p>Dashboard</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="registrar_arrendatario.php" class="nav-link">
                            <i class="nav-icon fas fa-user-plus"></i>
                            <p>Registrar Arrendatario</p>
                        </a>
                    </li>
                    <li class="nav-item">
				    <a href="cambiar_contrasena.php" class="nav-link">
				        <i class="nav-icon fas fa-key"></i>
				        <p>Cambiar Contraseña</p>
				    </a>
				</li>
                </ul>
            </nav>
        </div>
    </aside>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Propietario</h1>
                    </div>
                    <div class="col-sm-6">
                        <form method="GET" action="" class="d-flex justify-content-end">
                            <input type="text" name="search" class="form-control w-50 me-2" placeholder="Buscar arrendatario" value="<?php echo $search_query; ?>">
                            <button type="submit" class="btn btn-primary">Buscar</button>
                        </form>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <h4><p class="text-center">Bienvenido(a), <?php echo $_SESSION['nombre']; ?> - Departamento: <?php echo $numero_departamento; ?> - Estacionamiento: <?php echo $estacionamiento_departamento; ?> </p></h4>
          
                <table class="table table-striped">
                   <thead>
    <tr>
     
                            <th>Estado</th>
                           <th>Nombre</th>
                           <th>RUT</th>
                          
                           <th>Celular</th>
                           <th>Email</th>
                           <th>Fecha Inicio</th>
                           <th>Fecha Salida</th>
                           <th>Días Totales</th>
                           <th>Llegó</th>
                           <th>Salió</th>
                           <th>Registrado por</th>
                           <th>Patente Vehículo</th>
                           <th>Acompañantes</th>
                           <th>Generar Ficha</th>
                           <th>Editar</th>
                           <th>Eliminar</th>
                           <th>Correo</th>
    </tr>
</thead>
                   <tbody>


    <?php while ($arrendatario = $result_arrendatarios->fetch_assoc()): ?>
        <?php
        // Calcular estado del arriendo
        $fecha_actual = date("Y-m-d");
        $hora_actual = date("H:i:s");
        $estado = '';

        if ($fecha_actual < $arrendatario['fecha_inicio']) {
            $estado = 'Pendiente';
        } elseif (
            $fecha_actual >= $arrendatario['fecha_inicio'] &&
            $fecha_actual <= $arrendatario['fecha_salida'] 
           
        ) {
            $estado = 'En Arriendo';
        } else {
            $estado = 'Finalizado';
        }

        // Clases para los colores según el estado
        $clase_estado = ($estado === 'Pendiente') ? 'bg-warning' :
                        (($estado === 'En Arriendo') ? 'bg-success' : 'bg-danger');
        ?>


        <tr>
            
            <td><span class="badge <?php echo $clase_estado; ?>"><?php echo $estado; ?></span></td>
                               <td><?php echo $arrendatario['nombre']; ?></td>
                               <td><?php echo $arrendatario['rut']; ?></td>
                               
                               <td><?php echo $arrendatario['celular']; ?></td>
                               <td><?php echo $arrendatario['email']; ?></td>
                               <td><?php echo date("d-m-Y", strtotime($arrendatario['fecha_inicio'])); ?></td>
                               <td><?php echo date("d-m-Y", strtotime($arrendatario['fecha_salida'])); ?></td>
                               <td><?php echo $arrendatario['dias_totales']; ?></td>
                               <td><?php echo $arrendatario['llego'] ? date("d-m-Y H:i", strtotime($arrendatario['llego'])) : 'No'; ?></td>
                               <td><?php echo $arrendatario['salio'] ? date("d-m-Y H:i", strtotime($arrendatario['salio'])) : 'No'; ?></td>
                               <td><?php echo $arrendatario['conserje'] ?: 'N/A'; ?></td>
                               <td><?php echo $arrendatario['patente_vehiculo']; ?></td>
                               <td><button class="btn btn-success btn-sm" onclick="mostrarAcompanantes(<?php echo $arrendatario['id_arrendatario']; ?>)"><i class="glyphicon glyphicon-eye-open"></i></button></td>
                               <td><center>
            <a href="generar_ficha.php?id=<?php echo $arrendatario['id_arrendatario']; ?>&dias=<?php echo $arrendatario['dias_totales']; ?>" class="btn btn-info btn-sm"> <span class="glyphicon glyphicon-file"></span></a>
            </td> 
                               <td><a href="editar_arrendatario.php?id=<?php echo $arrendatario['id_arrendatario']; ?>" class="btn btn-warning btn-sm"><i class="glyphicon glyphicon-pencil"></i></a></td>
                               <td><a href="eliminar_arrendatario.php?id=<?php echo $arrendatario['id_arrendatario']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro de eliminar este arrendatario?')"><i class="glyphicon glyphicon-trash"></i></a></td>
                               <td><a href="#" onclick="window.open('envio_pdf.php?id=<?php echo $arrendatario['id_arrendatario']; ?>', '', 'width=800,height=600'); return false;" class="btn btn-warning"><i class="glyphicon glyphicon-envelope"></i></a></td>
                           </tr>
    <?php endwhile; ?>
</tbody>

                </table>
            </div>
        </section>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<!-- jQuery -->
<script src="/plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="/plugins/jszip/jszip.min.js"></script>
<script src="/plugins/pdfmake/pdfmake.min.js"></script>
<script src="/plugins/pdfmake/vfs_fonts.js"></script>
<script src="/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="/plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<!-- AdminLTE App -->
<script src="/dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="/dist/js/demo.js"></script>
<!-- Page specific script -->
<script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>

<script>
function mostrarAcompanantes(idArrendatario) {
    $.ajax({
        url: 'obtener_acompanantes.php', // Archivo PHP para obtener los datos
        type: 'GET',
        data: { id: idArrendatario },
        success: function(response) {
            Swal.fire({
                title: 'Acompañantes',
                html: response, // Contenido recibido del archivo PHP
                icon: 'info'
            });
        },
        error: function() {
            Swal.fire({
                title: 'Error',
                text: 'No se pudo obtener la información de los acompañantes.',
                icon: 'error'
            });
        }
    });
}
</script>
<!-- Alertas y cierre automático -->
<script>
    const tiempoInactividad = <?php echo TIEMPO_INACTIVIDAD * 1000; ?>;
    const tiempoAlerta = tiempoInactividad - 60000;

    setTimeout(() => {
        Swal.fire({
            title: "Inactividad detectada",
            text: "Tu sesión se cerrará en 1 minuto por inactividad.",
            icon: "warning",
            timer: 60000,
            timerProgressBar: true
        });
    }, tiempoAlerta);

    setTimeout(() => {
        window.location.href = "login.php";
    }, tiempoInactividad);
</script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>



</body>
</html>
