<?php
// vista_departamento_propietario.php
include 'conexion.php';

// Verificar si se proporciona el ID del propietario
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Error: ID de propietario no proporcionado.");
}

$id_propietario = $_GET['id'];

// Obtener detalles del propietario y sus departamentos
$stmt = $conn->prepare("SELECT u.nombre AS propietario_nombre, u.rut AS propietario_rut, p.numero_departamento, p.celular 
                         FROM propietarios p
                         JOIN usuarios u ON p.id_usuario = u.id_usuario
                         WHERE p.id_propietario = ?");
$stmt->bind_param("i", $id_propietario);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Error: Propietario no encontrado.");
}

$propietario = $result->fetch_assoc();

// Obtener arrendatarios asociados al propietario
$stmt_arrendatarios = $conn->prepare("SELECT nombre, rut, fecha_inicio, fecha_salida, patente_vehiculo
                                       FROM arrendatarios
                                       WHERE id_propietario = ?");
$stmt_arrendatarios->bind_param("i", $id_propietario);
$stmt_arrendatarios->execute();
$result_arrendatarios = $stmt_arrendatarios->get_result();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Departamento del Propietario</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
        </ul>
    </nav>

    <!-- Sidebar -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <a href="#" class="brand-link">
            <span class="brand-text font-weight-light">Sistema Arriendos</span>
        </a>
        <div class="sidebar">
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="info">
                    <a href="#" class="d-block">Administrador</a>
                </div>
            </div>
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
                    <li class="nav-item">
                        <a href="admin_dashboard.php" class="nav-link">
                            <i class="nav-icon fas fa-home"></i>
                            <p>Dashboard</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="vista_propietarios.php" class="nav-link">
                            <i class="nav-icon fas fa-eye"></i>
                            <p>Ver Propietarios</p>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </aside>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Detalles del Propietario</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Información del Propietario</h3>
                    </div>
                    <div class="card-body">
                        <p><strong>Nombre:</strong> <?php echo $propietario['propietario_nombre']; ?></p>
                        <p><strong>RUT:</strong> <?php echo $propietario['propietario_rut']; ?></p>
                        <p><strong>Número de Departamento:</strong> <?php echo $propietario['numero_departamento']; ?></p>
                        <p><strong>Celular:</strong> <?php echo $propietario['celular']; ?></p>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Arrendatarios Asociados</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Nombre</th>
                                    <th>RUT</th>
                                    <th>Fecha Inicio</th>
                                    <th>Fecha Salida</th>
                                    <th>Patente Vehículo</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($arrendatario = $result_arrendatarios->fetch_assoc()): ?>
                                    <tr>
                                        <td><?php echo $arrendatario['nombre']; ?></td>
                                        <td><?php echo $arrendatario['rut']; ?></td>
                                        <td><?php echo $arrendatario['fecha_inicio']; ?></td>
                                        <td><?php echo $arrendatario['fecha_salida']; ?></td>
                                        <td><?php echo $arrendatario['patente_vehiculo']; ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>
