<?php
session_start();
include 'conexion.php';

// Verificar si el usuario ha iniciado sesión y tiene el rol correcto
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'propietario') {
    header("Location: login.php");
    exit;
}

// Verificar que el ID esté presente en la URL
if (isset($_GET['id'])) {
    $id_arrendatario = intval($_GET['id']);

    // Obtener los datos del arrendatario
    $stmt = $conn->prepare("SELECT * FROM arrendatarios WHERE id_arrendatario = ?");
    $stmt->bind_param("i", $id_arrendatario);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $arrendatario = $result->fetch_assoc();
    } else {
        $_SESSION['mensaje'] = "Arrendatario no encontrado.";
        header("Location: propietario_dashboard.php");
        exit;
    }
} else {
    $_SESSION['mensaje'] = "ID de arrendatario no especificado.";
    header("Location: propietario_dashboard.php");
    exit;
}

// Inicializar $acompanantes como un arreglo vacío
$acompanantes = [];

// Obtener los acompañantes del arrendatario
$stmt_acomp = $conn->prepare("SELECT * FROM acompanantes WHERE id_arrendatario = ?");
$stmt_acomp->bind_param("i", $id_arrendatario);
$stmt_acomp->execute();
$result_acomp = $stmt_acomp->get_result();

if ($result_acomp->num_rows > 0) {
    $acompanantes = $result_acomp->fetch_all(MYSQLI_ASSOC);
}

// Procesar la actualización del formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $rut = $_POST['rut'];
    $direccion = $_POST['direccion'];
    $celular = $_POST['celular'];
    $email = $_POST['email'];
    $fecha_inicio = $_POST['fecha_inicio'];
    $fecha_salida = $_POST['fecha_salida'];
    $patente_vehiculo = $_POST['patente_vehiculo'];
    $autorizado_visitas = $_POST['autorizado_visitas'];
    $hora_ingreso = $_POST['hora_ingreso'];
    $hora_salida = $_POST['hora_salida'];

    $stmt = $conn->prepare("UPDATE arrendatarios SET nombre = ?, rut = ?, direccion = ?, celular = ?, email = ?, fecha_inicio = ?, fecha_salida = ?, patente_vehiculo = ?, autorizado_visitas = ?, hora_ingreso = ?, hora_salida = ? WHERE id_arrendatario = ?");
    $stmt->bind_param("sssssssssssi", $nombre, $rut, $direccion, $celular, $email, $fecha_inicio, $fecha_salida, $patente_vehiculo, $autorizado_visitas, $hora_ingreso, $hora_salida, $id_arrendatario);

    if ($stmt->execute()) {
        // Actualizar o eliminar acompañantes existentes
        if (!empty($_POST['acompanantes'])) {
            foreach ($_POST['acompanantes'] as $id_acompanante => $datos) {
                if (!empty($datos['nombre']) && !empty($datos['rut'])) {
                    $stmt_acomp_update = $conn->prepare("UPDATE acompanantes SET nombre = ?, rut = ? WHERE id_acompanante = ?");
                    $stmt_acomp_update->bind_param("ssi", $datos['nombre'], $datos['rut'], $id_acompanante);
                    $stmt_acomp_update->execute();
                } else {
                    $stmt_acomp_delete = $conn->prepare("DELETE FROM acompanantes WHERE id_acompanante = ?");
                    $stmt_acomp_delete->bind_param("i", $id_acompanante);
                    $stmt_acomp_delete->execute();
                }
            }
        }

        // Agregar nuevos acompañantes
        if (!empty($_POST['nuevo_acompanantes'])) {
            foreach ($_POST['nuevo_acompanantes'] as $nuevo) {
                if (!empty($nuevo['nombre']) && !empty($nuevo['rut'])) {
                    $stmt_acomp_insert = $conn->prepare("INSERT INTO acompanantes (id_arrendatario, nombre, rut) VALUES (?, ?, ?)");
                    $stmt_acomp_insert->bind_param("iss", $id_arrendatario, $nuevo['nombre'], $nuevo['rut']);
                    $stmt_acomp_insert->execute();
                }
            }
        }

        $_SESSION['mensaje'] = "Arrendatario y acompañantes actualizados con éxito.";
        header("Location: propietario_dashboard.php");
        exit;
    } else {
        $error = "Error al actualizar arrendatario: " . $stmt->error;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Arrendatario</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
        </ul>
    </nav>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Editar Arrendatario</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <form method="POST" action="">
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo $arrendatario['nombre']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="rut" class="form-label">RUT</label>
                        <input type="text" class="form-control" id="rut" name="rut" value="<?php echo $arrendatario['rut']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="direccion" class="form-label">Dirección</label>
                        <input type="text" class="form-control" id="direccion" name="direccion" value="<?php echo $arrendatario['direccion']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="celular" class="form-label">Celular</label>
                        <input type="text" class="form-control" id="celular" name="celular" value="<?php echo $arrendatario['celular']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Correo Electrónico</label>
                        <input type="email" class="form-control" id="email" name="email" value="<?php echo $arrendatario['email']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="fecha_inicio" class="form-label">Fecha Inicio</label>
                        <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio" value="<?php echo $arrendatario['fecha_inicio']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="fecha_salida" class="form-label">Fecha Salida</label>
                        <input type="date" class="form-control" id="fecha_salida" name="fecha_salida" value="<?php echo $arrendatario['fecha_salida']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="patente_vehiculo" class="form-label">Patente del Vehículo</label>
                        <input type="text" class="form-control" id="patente_vehiculo" name="patente_vehiculo" value="<?php echo $arrendatario['patente_vehiculo']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="autorizado_visitas" class="form-label">Autorizado Visitas</label>
                        <input type="text" class="form-control" id="autorizado_visitas" name="autorizado_visitas" value="<?php echo $arrendatario['autorizado_visitas']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="hora_ingreso" class="form-label">Hora Ingreso</label>
                        <input type="time" class="form-control" id="hora_ingreso" name="hora_ingreso" value="<?php echo $arrendatario['hora_ingreso']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="hora_salida" class="form-label">Hora Salida</label>
                        <input type="time" class="form-control" id="hora_salida" name="hora_salida" value="<?php echo $arrendatario['hora_salida']; ?>" required>
                    </div>

                    <h4>Agregar Nuevos Acompañantes</h4>
                    <div id="nuevo-acompanantes-container"></div>
                    <button type="button" class="btn btn-secondary mb-3" id="add-nuevo-acompanante">Agregar Nuevo Acompañante</button>

                    <script>
                        // Lógica para agregar campos para nuevos acompañantes
                        let nuevoAcompananteCount = 0;
                        document.getElementById('add-nuevo-acompanante').addEventListener('click', () => {
                            nuevoAcompananteCount++;
                            const container = document.getElementById('nuevo-acompanantes-container');
                            const div = document.createElement('div');
                            div.classList.add('mb-3');
                            div.innerHTML = `
                                <input type="text" class="form-control mt-2" name="nuevo_acompanantes[${nuevoAcompananteCount}][nombre]" placeholder="Nombre del nuevo acompañante">
                                <input type="text" class="form-control mt-2" name="nuevo_acompanantes[${nuevoAcompananteCount}][rut]" placeholder="RUT del nuevo acompañante">
                            `;
                            container.appendChild(div);
                        });
                    </script>

                    <h4>Acompañantes</h4>
                    <?php if (!empty($acompanantes)): ?>
                        <?php foreach ($acompanantes as $acompanante): ?>
                            <div class="mb-3">
            <input type="text" class="form-control" name="acompanantes[<?php echo $acompanante['id_acompanante']; ?>][nombre]" value="<?php echo $acompanante['nombre']; ?>" placeholder="Nombre del acompañante">
            <input type="text" class="form-control mt-2" name="acompanantes[<?php echo $acompanante['id_acompanante']; ?>][rut]" value="<?php echo $acompanante['rut']; ?>" placeholder="RUT del acompañante">
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <p>No hay acompañantes registrados para este arrendatario.</p>
<?php endif; ?>
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                    <a href="propietario_dashboard.php" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </section>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>
