<?php
// editar_propietario.php
include 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['id'])) {
    $id_propietario = $_GET['id'];

    $stmt = $conn->prepare("SELECT p.id_propietario, u.nombre, u.rut, p.numero_departamento, p.celular FROM propietarios p JOIN usuarios u ON p.id_usuario = u.id_usuario WHERE p.id_propietario = ?");
    $stmt->bind_param("i", $id_propietario);
    $stmt->execute();
    $result = $stmt->get_result();
    $propietario = $result->fetch_assoc();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id_propietario'])) {
    $id_propietario = $_POST['id_propietario'];
    $nombre = $_POST['nombre'];
    $rut = $_POST['rut'];
    $numero_departamento = $_POST['numero_departamento'];
    $celular = $_POST['celular'];

    $stmt = $conn->prepare("UPDATE propietarios p JOIN usuarios u ON p.id_usuario = u.id_usuario SET u.nombre = ?, u.rut = ?, p.numero_departamento = ?, p.celular = ? WHERE p.id_propietario = ?");
    $stmt->bind_param("sssii", $nombre, $rut, $numero_departamento, $celular, $id_propietario);

    if ($stmt->execute()) {
        echo "<div class='alert alert-success'>Propietario actualizado con éxito.</div>";
    } else {
        echo "<div class='alert alert-danger'>Error al actualizar: " . $stmt->error . "</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Propietario</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h2 class="text-center">Editar Propietario</h2>
    <?php if (isset($propietario)): ?>
        <form method="POST" action="">
            <input type="hidden" name="id_propietario" value="<?php echo $propietario['id_propietario']; ?>">
            <div class="mb-3">
                <label for="nombre" class="form-label">Nombre</label>
                <input type="text" class="form-control" name="nombre" value="<?php echo $propietario['nombre']; ?>" required>
            </div>
            <div class="mb-3">
                <label for="rut" class="form-label">RUT</label>
                <input type="text" class="form-control" name="rut" value="<?php echo $propietario['rut']; ?>" required>
            </div>
            <div class="mb-3">
                <label for="numero_departamento" class="form-label">Número de Departamento</label>
                <input type="text" class="form-control" name="numero_departamento" value="<?php echo $propietario['numero_departamento']; ?>" required>
            </div>
            <div class="mb-3">
                <label for="celular" class="form-label">Celular</label>
                <input type="text" class="form-control" name="celular" value="<?php echo $propietario['celular']; ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Actualizar</button>
        </form>
    <?php else: ?>
        <p class="alert alert-danger">Propietario no encontrado.</p>
    <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>