<?php
// Mostrar errores para depuracin
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Validar que las variables estn presentes en la URL
if (!isset($_GET['nombre'], $_GET['rut'], $_GET['email'], $_GET['fecha_inicio'], $_GET['fecha_salida'], $_GET['id'])) {
    die("Error: Faltan parmetros en la URL.");
}

// Decodificar las variables
$nombre = urldecode($_GET['nombre']);
$rut = urldecode($_GET['rut']);
$email = urldecode($_GET['email']);
$fecha_inicio = urldecode($_GET['fecha_inicio']);
$fecha_salida = urldecode($_GET['fecha_salida']);
$id = urldecode($_GET['id']);

// Verificar si se envi el formulario
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validar y procesar el formulario
    $destinatario = filter_var($_POST['destinatario'], FILTER_VALIDATE_EMAIL);

    if (!$destinatario) {
        echo "<script>alert('Correo electrnico invlido.');</script>";
        exit;
    }

    // Datos del correo
    $asunto = "Ficha de arriendo departamento 1031 de $nombre";
    $ficha = "https://misarriendos.cl/agenda/EDITAR_PDF/Editar_PDF_CON_FPDI-master/asignar_variables_al_pdf2.php?variable6=" . urlencode($id);
    $mapa = "https://www.google.com/maps/place/Lincoln+Nte.+2200,+Las+Cruces,+El+Tabo,+Valpara%C3%ADso";

    $mensaje = "
        <p>Estimado(a),</p>
        <p>La ficha corresponde a <strong>$rut</strong>, con ingreso este <strong>$fecha_inicio</strong> y salida el <strong>$fecha_salida</strong>.</p>
        <p><strong>Ficha de ingreso:</strong> <a href='$ficha'>Haz clic aqu para verla</a></p>
        <p><strong>Ubicacin:</strong> <a href='$mapa'>Haz clic aqu para verla</a></p>
        <p>Saludos,</p>
    ";

    $cabeceras = "MIME-Version: 1.0" . "\r\n";
    $cabeceras .= "Content-type: text/html; charset=UTF-8" . "\r\n";
    $cabeceras .= "From: no-reply@misarriendos.cl" . "\r\n";

    // Enviar el correo
    if (mail($destinatario, $asunto, $mensaje, $cabeceras)) {
        echo "<script>
                alert('Correo enviado correctamente.');
                setTimeout(function() { window.close(); }, 1000);
              </script>";
    } else {
        echo "<script>
                alert('Error al enviar el correo.');
                setTimeout(function() { window.close(); }, 1000);
              </script>";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Enviar Correo</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <h1 class="mb-4">Enviar Correo</h1>
        <form action="" method="POST">
            <div class="form-group">
                <label for="destinatario">Ingresar Destinatario para que reciba ficha de <?php echo htmlspecialchars($rut); ?>:</label>
                <input type="email" class="form-control" id="destinatario" name="destinatario" value="<?php echo htmlspecialchars($email); ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Enviar Ficha</button>
        </form>
    </div>
</body>
</html>
