<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Incluir PHPMailer (asegúrate de haberlo instalado correctamente)
//require 'vendor/autoload.php';

// Obtener los datos de la URL
$nombre = $_GET['nombre'] ?? 'Sin Nombre';
$rut = $_GET['rut'] ?? 'Sin RUT';
$email = $_GET['email'] ?? '';
$fecha_inicio = $_GET['fecha_inicio'] ?? 'N/A';
$fecha_salida = $_GET['fecha_salida'] ?? 'N/A';

// Validar el email
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    die('Correo inválidoddd.');
}

// Crear el PDF (usa una biblioteca como TCPDF o FPDI si no tienes uno preexistente)
// Aquí puedes generar dinámicamente el contenido del PDF
$pdf_content = "
    <h1>Ficha de Arrendatario</h1>
    <p><strong>Nombre:</strong> $nombre</p>
    <p><strong>RUT:</strong> $rut</p>
    <p><strong>Fecha de Inicio:</strong> $fecha_inicio</p>
    <p><strong>Fecha de Salida:</strong> $fecha_salida</p>
";

// Guardar el PDF temporalmente
$pdf_file = 'ficha_arrendatario.pdf';
file_put_contents($pdf_file, $pdf_content);

// Configurar PHPMailer
$mail = new PHPMailer(true);

try {
    // Configuración del servidor SMTP
    $mail->isSMTP();
    $mail->Host = 'smtp.gmail.com'; // Cambia según tu servidor SMTP
    $mail->SMTPAuth = true;
    $mail->Username = 'tu_correo@gmail.com'; // Cambia por tu correo
    $mail->Password = 'tu_contraseña'; // Cambia por tu contraseña
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;

    // Configuración del correo
    $mail->setFrom('tu_correo@gmail.com', 'Sistema Arriendos');
    $mail->addAddress($email, $nombre);

    // Adjuntar el PDF
    $mail->addAttachment($pdf_file);

    // Contenido del mensaje
    $mail->isHTML(true);
    $mail->Subject = 'Ficha de Arrendatario';
    $mail->Body = "
        <h1>Hola, $nombre</h1>
        <p>Adjunto encontrarás la ficha de tu arrendatario.</p>
    ";

    // Enviar correo
    $mail->send();
    echo 'Correo enviado exitosamente.';

    // Eliminar el archivo PDF temporal
    unlink($pdf_file);
} catch (Exception $e) {
    echo "Error al enviar el correo: {$mail->ErrorInfo}";
}
?>
