<?php

header('Content-Type: text/html; charset=UTF-8');

include 'conexion.php';
use setasign\Fpdi\Fpdi;

require_once('EDITAR_PDF/Editar_PDF_CON_FPDI-master/fpdf181/fpdf.php'); 
require_once('EDITAR_PDF/Editar_PDF_CON_FPDI-master/fpdi2/src/autoload.php');

$id_arrendatario = $_GET['id'];
$dias = $_GET['dias'];

// Obtener los datos del arrendatario
$stmt = $conn->prepare("
    SELECT 
        a.nombre AS arrendatario_nombre, a.rut AS arrendatario_rut, 
        a.direccion, a.celular, a.email, 
        a.fecha_inicio, a.fecha_salida, 
        a.hora_ingreso, a.hora_salida, 
        a.patente_vehiculo, a.autorizado_visitas,
        p.numero_departamento, p.estacionamiento, 
        u.nombre as propietario_nombre
    FROM arrendatarios a
    JOIN propietarios p ON a.id_propietario = p.id_propietario
    JOIN usuarios u ON u.id_usuario = p.id_usuario
    WHERE a.id_arrendatario = ?
");
$stmt->bind_param("i", $id_arrendatario);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $data = $result->fetch_assoc();

    // Obtener los acompañantes
    $stmt_acomp = $conn->prepare("SELECT nombre, rut FROM acompanantes WHERE id_arrendatario = ?");
    $stmt_acomp->bind_param("i", $id_arrendatario);
    $stmt_acomp->execute();
    $result_acomp = $stmt_acomp->get_result();

    // Crear instancia de FPDI
    $pdf = new Fpdi();

    // Cargar el PDF existente
    $pageCount = $pdf->setSourceFile('EDITAR_PDF/Editar_PDF_CON_FPDI-master/Files_Pdf/Ficha_arrendatario_lagunamar_6.pdf');
    $templateId = $pdf->importPage(1);
    $pdf->AddPage();
    $pdf->useTemplate($templateId);

    // Variables
    $direcciondpto = utf8_decode('Dirección Depto: Condominio Lagunamar Las Cruces, 2200 Lincoln Norte, Las Cruces, El Tabo, Valparaíso.');
    $visitas = utf8_decode("Autorizado para recibir visitas: ") . $data['autorizado_visitas'];
    $propietarios = utf8_decode("Propietario(a): ") . $data['propietario_nombre'];
    $Ficha_arrendatario = utf8_decode("FICHA ARRENDATARIO");

    $numero_departamento = $data['numero_departamento'];
    $piso = substr($numero_departamento, 1, 2); 

    // Configurar fuente y agregar texto
    $pdf->SetFont('Arial', '', 12);

    // Encabezado
    $pdf->SetFont('Arial', 'B', 15);
    $pdf->SetXY(77, 16);
    $pdf->Write(9, $Ficha_arrendatario);

    // Datos del propietario
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->SetXY(78, 20);
    $pdf->Write(9, $propietarios);

    // Datos del arrendatario
    $pdf->SetFont('Arial', 'b', 11);
    $pdf->SetXY(61, 32.5);
    $pdf->Write(10, utf8_decode($data['arrendatario_nombre']));

    $pdf->SetFont('Arial', 'b', 10);
    $pdf->SetXY(140, 32.5);
    $pdf->Write(10, utf8_decode($data['arrendatario_rut']));

    $pdf->SetFont('Arial', 'b', 11);
    $pdf->SetXY(40, 42.5);
    $pdf->Write(10, utf8_decode($data['direccion']));

    $pdf->SetFont('Arial', 'b', 10);
    $pdf->SetXY(140, 53);
    $pdf->Write(10, utf8_decode($data['celular']));

    $pdf->SetXY(58, 63);
    $pdf->Write(10, utf8_decode($data['email']));

    $pdf->SetFont('Arial', 'b', 10);
    $pdf->SetXY(58, 76);
    $pdf->Write(10, $dias);

    $pdf->SetFont('Arial', 'b', 10);
    $pdf->SetXY(116, 77);
    $pdf->Write(8, utf8_decode($data['numero_departamento']) . ' Piso ' .$piso);
    
     $pdf->SetFont('Arial', 'b', 12);
    $pdf->SetXY(182, 76.5);
    $pdf->Write(10, utf8_decode($data['estacionamiento']));

    $pdf->SetXY(32, 87);
    $pdf->Write(10, date("d-m-Y", strtotime($data['fecha_inicio'])));

    $pdf->SetXY(80, 87);
    $pdf->Write(10, date("d-m-Y", strtotime($data['fecha_salida'])));

    // Texto adicional
    $pdf->SetXY(17, 97);
    $pdf->Write(9, $visitas);

    $pdf->SetFont('Arial', 'b', 10);
    $pdf->SetXY(18, 262);
    $pdf->Write(10, $direcciondpto);

     $pdf->SetFont('Arial', 'B', '10'); 
    $pdf->SetXY(55, 197);
    $pdf->Write(10,  $data['patente_vehiculo']);

    $pdf->SetXY(55, 217);
    $pdf->Write(10, date("H:i", strtotime($data['hora_ingreso'])));

    $pdf->SetXY(55, 234.5);
    $pdf->Write(10, date("H:i", strtotime($data['hora_salida'])));

    // Acompañantes
    $y = 126;
    while ($acompanante = $result_acomp->fetch_assoc()) {
        $pdf->SetXY(27, $y);
        $pdf->Write(6, utf8_decode($acompanante['nombre']));
        $pdf->SetXY(120, $y);
        $pdf->Write(6, utf8_decode($acompanante['rut']));
        $y += 8;
    }


        
# Pagina 2
    $pdf->AddPage(); 
    $tplIdx1 = $pdf->importPage(2); 
    $pdf->useTemplate($tplIdx1);



    // Mostrar PDF
    $pdf->Output('Ficha_Arriendo_' . utf8_decode($data['arrendatario_nombre']) . '.pdf', 'I');
} else {
    echo "<div class='alert alert-danger'>No se encontraron datos para este arrendatario.</div>";
}


?>
