<?php
// Conexión a la base de datos
include 'conexion.php';

// Crear tabla lista negra (solo se ejecuta una vez)
$query = "CREATE TABLE IF NOT EXISTS lista_negra (
    id INT AUTO_INCREMENT PRIMARY KEY,
    rut VARCHAR(20) UNIQUE NOT NULL,
    nombre VARCHAR(100) NOT NULL,
    motivo VARCHAR(255) NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";
if (!$conn->query($query)) {
    die("Error al crear la tabla lista negra: " . $conn->error);
}

// Procesar formulario para agregar usuarios a la lista negra
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $rut = $_POST['rut'];
    $motivo = $_POST['motivo'];

    $stmt = $conn->prepare("INSERT INTO lista_negra (nombre, rut, motivo) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $nombre, $rut, $motivo);

    if ($stmt->execute()) {
        $mensaje = "Usuario agregado a la lista negra correctamente.";
    } else {
        $mensaje = "Error al agregar a la lista negra: " . $stmt->error;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrar en Lista Negra</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" href="propietario_dashboard.php"><i class="fas fa-home"></i> Inicio</a>
            </li>
        </ul>
    </nav>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Registrar en Lista Negra</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if (isset($mensaje)): ?>
                    <div class="alert alert-info"> <?php echo $mensaje; ?> </div>
                <?php endif; ?>

                <form method="POST" action="" class="form-horizontal">
                    <div class="card card-primary">
                        <div class="card-body">
                            <div class="form-group">
                                <label for="nombre">Nombre</label>
                                <input type="text" name="nombre" class="form-control" id="nombre" placeholder="Nombre completo" required>
                            </div>
                            <div class="form-group">
                                <label for="rut">RUT</label>
                                <input type="text" name="rut" class="form-control" id="rut" placeholder="RUT (sin puntos, con guión)" required>
                            </div>
                            <div class="form-group">
                                <label for="motivo">Motivo</label>
                                <textarea name="motivo" class="form-control" id="motivo" rows="3" placeholder="Motivo del registro" required></textarea>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Agregar a Lista Negra</button>
                            <a href="propietario_dashboard.php" class="btn btn-secondary">Cancelar</a>
                        </div>
                    </div>
                </form>
            </div>
        </section>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>

<?php
// Validación en el formulario de registro de arrendatarios
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rut = $_POST['rut'];

    // Validar si el RUT está en la lista negra
    $stmt = $conn->prepare("SELECT * FROM lista_negra WHERE rut = ?");
    $stmt->bind_param("s", $rut);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo "<div class='alert alert-danger'>El RUT $rut está en la lista negra y no puede registrarse como arrendatario o acompañante.</div>";
        exit;
    }
}
?>
