<?php
session_start();
include 'conexion.php';

// Verificar si el usuario tiene rol de administrador
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
    header("Location: login.php");
    exit;
}

// Obtener todos los conserjes
$stmt = $conn->prepare("SELECT * FROM usuarios WHERE rol = 'conserje' ORDER BY id_usuario ASC");
$stmt->execute();
$result = $stmt->get_result();

// Eliminar un conserje
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['eliminar'])) {
    $id_usuario = $_POST['id_usuario'];

    $stmt_delete = $conn->prepare("DELETE FROM usuarios WHERE id_usuario = ?");
    $stmt_delete->bind_param("i", $id_usuario);

    if ($stmt_delete->execute()) {
        $_SESSION['mensaje'] = "Conserje eliminado con éxito.";
    } else {
        $_SESSION['mensaje'] = "Error al eliminar conserje: " . $stmt_delete->error;
    }
    header("Location: listar_conserjes.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Conserjes</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h1 class="mb-4">Lista de Conserjes</h1>

    <?php if (isset($_SESSION['mensaje'])): ?>
        <div class="alert alert-info">
            <?php
            echo $_SESSION['mensaje'];
            unset($_SESSION['mensaje']);
            ?>
        </div>
    <?php endif; ?>

    <table class="table table-striped">
        <thead>
        <tr>
            <th>#</th>
            <th>Nombre</th>
            <th>RUT</th>
            <th>Email</th>
            <th>Estado</th>
            <th>Acciones</th>
        </tr>
        </thead>
        <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo $row['id_usuario']; ?></td>
                <td><?php echo htmlspecialchars($row['nombre']); ?></td>
                <td><?php echo htmlspecialchars($row['rut']); ?></td>
                <td><?php echo htmlspecialchars($row['email']); ?></td>
                <td><?php echo ucfirst($row['estado']); ?></td>
                <td>
                    <a href="editar_conserje.php?id=<?php echo $row['id_usuario']; ?>" class="btn btn-warning btn-sm">Editar</a>
                    <form method="POST" style="display:inline;">
                        <input type="hidden" name="id_usuario" value="<?php echo $row['id_usuario']; ?>">
                        <button type="submit" name="eliminar" class="btn btn-danger btn-sm">Eliminar</button>
                    </form>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>

    <a href="admin_dashboard.php" class="btn btn-secondary">Volver</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
