<?php
session_start();
include 'conexion.php';

// Verificar si el usuario tiene rol de administrador
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'admin') {
    header("Location: login.php");
    exit;
}

// Obtener todos los registros de la lista negra
$stmt = $conn->prepare("SELECT * FROM lista_negra ORDER BY fecha_registro DESC");
$stmt->execute();
$result = $stmt->get_result();

// Eliminar un registro de la lista negra
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['eliminar'])) {
    $id = $_POST['id'];

    $stmt_delete = $conn->prepare("DELETE FROM lista_negra WHERE id = ?");
    $stmt_delete->bind_param("i", $id);

    if ($stmt_delete->execute()) {
        $_SESSION['mensaje'] = "Registro eliminado con éxito.";
    } else {
        $_SESSION['mensaje'] = "Error al eliminar registro: " . $stmt_delete->error;
    }
    header("Location: listar_lista_negra.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista Negra</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h1 class="mb-4">Personas en Lista Negra</h1>

    <?php if (isset($_SESSION['mensaje'])): ?>
        <div class="alert alert-info">
            <?php
            echo $_SESSION['mensaje'];
            unset($_SESSION['mensaje']);
            ?>
        </div>
    <?php endif; ?>

    <table class="table table-striped">
        <thead>
        <tr>
            <th>#</th>
            <th>Nombre</th>
            <th>RUT</th>
            <th>Motivo</th>
            <th>Fecha Agregado</th>
            <th>Acciones</th>
        </tr>
        </thead>
        <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo $row['id']; ?></td>
                <td><?php echo htmlspecialchars($row['nombre']); ?></td>
                <td><?php echo htmlspecialchars($row['rut']); ?></td>
                <td><?php echo htmlspecialchars($row['motivo']); ?></td>
                <td><?php echo date("d-m-Y H:i:s", strtotime($row['fecha_registro'])); ?></td>
                <td>
                    <form method="POST" style="display:inline;">
                        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                        <button type="submit" name="eliminar" class="btn btn-danger btn-sm">Eliminar</button>
                    </form>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>

    <a href="admin_dashboard.php" class="btn btn-secondary">Volver</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
