<?php
session_start();
include 'conexion.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM usuarios WHERE email = ?");
    if (!$stmt) {
        die("Error en la consulta: " . $conn->error);
    }

    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        // Verificar si el usuario está bloqueado
        if ($user['estado'] === 'bloqueado') {
            echo "<div class='alert alert-danger'>Su cuenta está bloqueada. Contacte al administrador.</div>";
        } elseif (password_verify($password, $user['password'])) {
            // Iniciar sesión
            $_SESSION['id_usuario'] = $user['id_usuario'];
            $_SESSION['rol'] = $user['rol'];
            $_SESSION['nombre'] = $user['nombre'];

            // Redirigir según el rol
            if ($user['rol'] === 'admin') {
                header("Location: admin_dashboard.php");
            } elseif ($user['rol'] === 'propietario') {
                header("Location: propietario_dashboard.php");
            } elseif ($user['rol'] === 'conserje') {
                header("Location: conserje_dashboard.php");
            } else {
                echo "<div class='alert alert-danger'>Rol desconocido.</div>";
            }
            exit;
        } else {
            echo "<div class='alert alert-danger'>Contraseña incorrecta.</div>";
        }
    } else {
        echo "<div class='alert alert-danger'>Usuario no encontrado.</div>";
    }
}
?>

<?php
if (isset($_GET['mensaje']) && $_GET['mensaje'] === 'inactividad') {
    echo "<div class='alert alert-warning'>Tu sesión se ha cerrado por inactividad.</div>";
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
</head>
<body class="hold-transition login-page">
<div class="login-box">
    <div class="card card-outline card-primary">
        <div class="card-header text-center">
            <h1><b>Sistema de Arriendos</b></h1>
        </div>
        <div class="card-body">
            <p class="login-box-msg">Inicia sesión para continuar</p>
            <form method="POST" action="login.php">
                <div class="input-group mb-3">
                    <input type="email" class="form-control" name="email" placeholder="Correo Electrónico" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="password" class="form-control" name="password" placeholder="Contraseña" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-lock"></span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary btn-block">Iniciar Sesión</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>
