<?php
session_start();
include 'conexion.php';

header('Content-Type: text/html; charset=UTF-8');

// Verificar si el usuario ha iniciado sesión y tiene el rol de propietario
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'propietario') {
    header("Location: login.php");
    exit;
}

$id_usuario = $_SESSION['id_usuario'];

// Obtener el ID del propietario basado en el usuario
$stmt = $conn->prepare("SELECT id_propietario FROM propietarios WHERE id_usuario = ?");
$stmt->bind_param("i", $id_usuario);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $row = $result->fetch_assoc();
    $id_propietario = $row['id_propietario'];
} else {
    echo "<div class='alert alert-danger'>Propietario no encontrado.</div>";
    exit;
}

// Procesar el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $rut = $_POST['rut'];
    $direccion = $_POST['direccion'];
    $celular = $_POST['celular'];
    $email = $_POST['email'];
    $fecha_inicio = $_POST['fecha_inicio'];
    $fecha_salida = $_POST['fecha_salida'];
    $autorizado_visitas = $_POST['autorizado_visitas'];
    $hora_ingreso = $_POST['hora_ingreso'];
    $hora_salida = $_POST['hora_salida'];
    $patente_vehiculo = $_POST['patente_vehiculo'];

    // Validar si el RUT del arrendatario está en la lista negra
    $stmt_lista_negra = $conn->prepare("SELECT * FROM lista_negra WHERE rut = ?");
    $stmt_lista_negra->bind_param("s", $rut);
    $stmt_lista_negra->execute();
    $result_lista_negra = $stmt_lista_negra->get_result();

    if ($result_lista_negra->num_rows > 0) {
        $error = "El RUT $rut está en la lista negra y no puede registrarse como arrendatario.";
    } else {
        // Insertar el arrendatario
        $stmt = $conn->prepare("INSERT INTO arrendatarios (id_propietario, nombre, rut, direccion, celular, email, fecha_inicio, fecha_salida, autorizado_visitas, hora_ingreso, hora_salida, patente_vehiculo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("isssssssssss", $id_propietario, $nombre, $rut, $direccion, $celular, $email, $fecha_inicio, $fecha_salida, $autorizado_visitas, $hora_ingreso, $hora_salida, $patente_vehiculo);

        if ($stmt->execute()) {
            $id_arrendatario = $conn->insert_id;

            // Insertar acompañantes
            if (!empty($_POST['acompanantes'])) {
                foreach ($_POST['acompanantes'] as $acompanante) {
                    if (!empty($acompanante['nombre']) && !empty($acompanante['rut'])) {
                        $acompanante_nombre = $acompanante['nombre'];
                        $acompanante_rut = $acompanante['rut'];

                        // Validar si el RUT del acompañante está en la lista negra
                        $stmt_lista_negra_acomp = $conn->prepare("SELECT * FROM lista_negra WHERE rut = ?");
                        $stmt_lista_negra_acomp->bind_param("s", $acompanante_rut);
                        $stmt_lista_negra_acomp->execute();
                        $result_lista_negra_acomp = $stmt_lista_negra_acomp->get_result();

                        if ($result_lista_negra_acomp->num_rows > 0) {
                            $error = "El acompañante con RUT $acompanante_rut está en la lista negra y no puede registrarse.";
                            break;
                        }

                        $stmt_acomp = $conn->prepare("INSERT INTO acompanantes (id_arrendatario, nombre, rut) VALUES (?, ?, ?)");
                        $stmt_acomp->bind_param("iss", $id_arrendatario, $acompanante_nombre, $acompanante_rut);
                        $stmt_acomp->execute();
                    }
                }
            }

   if (!isset($error)) {
    // Configuración para caracteres con acentos
    echo "<!DOCTYPE html>
    <html lang='es'>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <title>Redirección</title>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    </head>
    <body>
        <script>
            Swal.fire({
                icon: 'success',
                title: '¡Éxito!',
                text: 'Arrendatario y acompañantes registrados con éxito. Serás redirigido en unos segundos...',
                timer: 5000,
                timerProgressBar: true,
                showConfirmButton: false
            }).then(() => {
                window.location.href = 'https://misarriendos.cl/arriendos/propietario_dashboard.php';
            });
        </script>
    </body>
    </html>";
    exit;
}


        } else {
            
            
            
            $error = "Error al registrar: " . $stmt->error;
        }
    }
}
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrar Arrendatario</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
        </ul>
    </nav>

    <!-- Sidebar -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <a href="#" class="brand-link">
            <span class="brand-text font-weight-light">Sistema Arriendos</span>
        </a>
        <div class="sidebar">
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="info">
                    <a href="#" class="d-block">Propietario</a>
                </div>
            </div>
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
                    <li class="nav-item">
                        <a href="propietario_dashboard.php" class="nav-link">
                            <i class="nav-icon fas fa-home"></i>
                            <p>Dashboard</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#" class="nav-link active">
                            <i class="nav-icon fas fa-user-plus"></i>
                            <p>Registrar Arrendatario</p>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </aside>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Registrar Arrendatario</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                <form method="POST" action="" class="needs-validation" novalidate>
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                        <div class="invalid-feedback">Por favor, ingresa el nombre.</div>
                    </div>
                    <div class="mb-3">
                        <label for="rut" class="form-label">RUT</label>
                        <input type="text" class="form-control" id="rut" name="rut" required>
                        <div class="invalid-feedback">Por favor, ingresa el RUT.</div>
                    </div>
                    <div class="mb-3">
                        <label for="direccion" class="form-label">Dirección</label>
                        <input type="text" class="form-control" id="direccion" name="direccion" required>
                        <div class="invalid-feedback">Por favor, ingresa la dirección.</div>
                    </div>
                    <div class="mb-3">
                        <label for="celular" class="form-label">Celular</label>
                        <input type="text" class="form-control" id="celular" name="celular" required>
                        <div class="invalid-feedback">Por favor, ingresa el número de celular.</div>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Correo Electrónico</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                        <div class="invalid-feedback">Por favor, ingresa un correo válido.</div>
                    </div>
                    <div class="mb-3">
                        <label for="fecha_inicio" class="form-label">Fecha Inicio</label>
                        <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio" required>
                        <div class="invalid-feedback">Por favor, ingresa la fecha de inicio.</div>
                    </div>
                    <div class="mb-3">
                        <label for="fecha_salida" class="form-label">Fecha Salida</label>
                        <input type="date" class="form-control" id="fecha_salida" name="fecha_salida" required>
                        <div class="invalid-feedback">Por favor, ingresa la fecha de salida.</div>
                    </div>
                    <div class="mb-3">
                        <label for="autorizado_visitas" class="form-label">Autorizado Visitas</label>
                        <select class="form-control" id="autorizado_visitas" name="autorizado_visitas" required>
                            <option value="">Seleccione</option>
                            <option value="SI">Sí</option>
                            <option value="NO">No</option>
                        </select>
                        <div class="invalid-feedback">Por favor, selecciona una opción.</div>
                    </div>
                    <div class="mb-3">
                        <label for="hora_ingreso" class="form-label">Hora Ingreso</label>
                        <input type="time" class="form-control" id="hora_ingreso" name="hora_ingreso" required>
                        <div class="invalid-feedback">Por favor, ingresa la hora de ingreso.</div>
                    </div>
                    <div class="mb-3">
                        <label for="hora_salida" class="form-label">Hora Salida</label>
                        <input type="time" class="form-control" id="hora_salida" name="hora_salida" required>
                        <div class="invalid-feedback">Por favor, ingresa la hora de salida.</div>
                    </div>
                    <div class="mb-3">
                        <label for="patente_vehiculo" class="form-label">Patente Vehículo</label>
                        <input type="text" class="form-control" id="patente_vehiculo" name="patente_vehiculo">
                        <div class="invalid-feedback">Por favor, ingresa la patente del vehículo.</div>
                    </div>

                    <!-- Acompañantes -->
                    <h4 class="mt-4">Acompañantes</h4>
                    <div id="acompanantes-container"></div>
                    <button type="button" id="add-acompanante" class="btn btn-secondary mb-3">Agregar Acompañante</button>

                    <!-- Botones -->
                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary">Registrar Arrendatario</button>
                        <a href="propietario_dashboard.php" class="btn btn-secondary ms-2">Volver</a>
                    </div>
                </form>
            </div>
        </section>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script>
// Validación del formulario con Bootstrap
(() => {
    'use strict';
    const forms = document.querySelectorAll('.needs-validation');

    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }

            form.classList.add('was-validated');
        }, false);
    });
})();

// Lógica para agregar acompañantes
let acompananteCount = 0;
document.getElementById('add-acompanante').addEventListener('click', () => {
    if (acompananteCount < 7) {
        acompananteCount++;
        const container = document.getElementById('acompanantes-container');
        const div = document.createElement('div');
        div.classList.add('mb-3');
        div.innerHTML = `
            <label for="acompanante_nombre_${acompananteCount}" class="form-label">Nombre Acompañante ${acompananteCount}</label>
            <input type="text" class="form-control" id="acompanante_nombre_${acompananteCount}" name="acompanantes[${acompananteCount}][nombre]">
            <label for="acompanante_rut_${acompananteCount}" class="form-label">RUT Acompañante ${acompananteCount}</label>
            <input type="text" class="form-control" id="acompanante_rut_${acompananteCount}" name="acompanantes[${acompananteCount}][rut]">
        `;
        container.appendChild(div);
    } else {
      
        alert('No puedes agregar más de 7 acompañantes.');
    }
});
</script>
</body>
</html>
