<?php
session_start();
include 'conexion.php';

// Configurar zona horaria
date_default_timezone_set('America/Santiago');

// Verificar si el usuario tiene rol de conserje
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'conserje') {
    header("Location: login.php");
    exit;
}

// Verificar que el ID del usuario y del arrendatario estén presentes
if (!isset($_POST['id_arrendatario']) || !isset($_SESSION['id_usuario'])) {
    $_SESSION['mensaje'] = "Error: No se recibieron los datos necesarios.";
    header("Location: conserje_dashboard.php");
    exit;
}

$id_arrendatario = $_POST['id_arrendatario'];
$registrado_por = $_SESSION['id_usuario'];

// Determinar si es llegada o salida
if (isset($_POST['registrar_llegada'])) {
    $tipo_registro = 'llegada';
    $column = 'fecha_hora_llegada';
} elseif (isset($_POST['registrar_salida'])) {
    $tipo_registro = 'salida';
    $column = 'fecha_hora_salida';
} else {
    $_SESSION['mensaje'] = "Error: Acción no reconocida.";
    header("Location: conserje_dashboard.php");
    exit;
}

// Registrar la llegada o salida en la tabla 'registros'
$fecha_hora_actual = date("Y-m-d H:i:s");
$query = "
    INSERT INTO registros (id_arrendatario, $column, registrado_por)
    VALUES (?, ?, ?)
    ON DUPLICATE KEY UPDATE 
        $column = VALUES($column),
        registrado_por = VALUES(registrado_por);
";

$stmt = $conn->prepare($query);

if ($stmt) {
    $stmt->bind_param("isi", $id_arrendatario, $fecha_hora_actual, $registrado_por);

    if ($stmt->execute()) {
        $_SESSION['mensaje'] = "Registro de $tipo_registro exitoso para el arrendatario.";
    } else {
        $_SESSION['mensaje'] = "Error al registrar $tipo_registro: " . $stmt->error;
    }

    $stmt->close();
} else {
    $_SESSION['mensaje'] = "Error en la preparación de la consulta: " . $conn->error;
}

header("Location: conserje_dashboard.php");
exit;
?>
