<?php
include 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $rut = $_POST['rut'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $numero_departamento = $_POST['numero_departamento'];
    $celular = $_POST['celular'];
    $estacionamiento = $_POST['estacionamiento'];

    $conn->begin_transaction();

    try {
        // Insertar en usuarios
        $stmt1 = $conn->prepare("INSERT INTO usuarios (nombre, rut, email, password, rol) VALUES (?, ?, ?, ?, 'propietario')");
        if (!$stmt1) {
            throw new Exception("Error al preparar la consulta de usuarios: " . $conn->error);
        }
        $stmt1->bind_param("ssss", $nombre, $rut, $email, $password);
        if (!$stmt1->execute()) {
            throw new Exception("Error al insertar en usuarios: " . $stmt1->error);
        }
        $id_usuario = $conn->insert_id;

        // Insertar en propietarios
        $stmt2 = $conn->prepare("INSERT INTO propietarios (id_usuario, numero_departamento, celular, estacionamiento) VALUES (?, ?, ?,?)");
        if (!$stmt2) {
            throw new Exception("Error al preparar la consulta de propietarios: " . $conn->error);
        }
        $stmt2->bind_param("isss", $id_usuario, $numero_departamento, $celular, $estacionamiento);
        if (!$stmt2->execute()) {
            throw new Exception("Error al insertar en propietarios: " . $stmt2->error);
        }

        $conn->commit();
        echo "<script>Swal.fire({title: 'Éxito', text: 'Propietario registrado con éxito.', icon: 'success'}).then(() => { window.location.href = 'admin_dashboard.php'; });</script>";
    } catch (Exception $e) {
        $conn->rollback();
        echo "<script>Swal.fire({title: 'Error', text: '" . addslashes($e->getMessage()) . "', icon: 'error'});</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrar Propietario</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
        </ul>
    </nav>

    <!-- Sidebar -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <a href="#" class="brand-link">
            <span class="brand-text font-weight-light">Sistema Arriendos</span>
        </a>
        <div class="sidebar">
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
                    <li class="nav-item">
                        <a href="admin_dashboard.php" class="nav-link">
                            <i class="nav-icon fas fa-home"></i>
                            <p>Dashboard</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="registrar_propietario.php" class="nav-link active">
                            <i class="nav-icon fas fa-user-plus"></i>
                            <p>Registrar Propietario</p>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </aside>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Registrar Propietario</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="" class="needs-validation" novalidate>
                            <div class="mb-3">
                                <label for="nombre" class="form-label">Nombre</label>
                                <input type="text" class="form-control" id="nombre" name="nombre" required>
                                <div class="invalid-feedback">Por favor, ingresa el nombre.</div>
                            </div>
                            <div class="mb-3">
                                <label for="rut" class="form-label">RUT</label>
                                <input type="text" class="form-control" id="rut" name="rut" required>
                                <div class="invalid-feedback">Por favor, ingresa el RUT.</div>
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Correo Electrónico</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                                <div class="invalid-feedback">Por favor, ingresa un correo válido.</div>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Contraseña</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                                <div class="invalid-feedback">Por favor, ingresa una contraseña.</div>
                            </div>
                            <div class="mb-3">
                                <label for="numero_departamento" class="form-label">Número de Departamento</label>
                                <input type="text" class="form-control" id="numero_departamento" name="numero_departamento" required>
                                <div class="invalid-feedback">Por favor, ingresa el número del departamento.</div>
                            </div>
                            <div class="mb-3">
                                <label for="celular" class="form-label">Celular</label>
                                <input type="text" class="form-control" id="celular" name="celular" required>
                                <div class="invalid-feedback">Por favor, ingresa el número de celular.</div>
                            </div>
                             <div class="mb-3">
                                <label for="estacionamiento" class="form-label">Estacionamiento</label>
                                <input type="text" class="form-control" id="estacionamiento" name="estacionamiento" required>
                                <div class="invalid-feedback">Por favor, ingresa el número de estacionamiento.</div>
                            </div>
                            <button type="submit" class="btn btn-primary w-100">Registrar Propietario</button>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Validación del formulario con Bootstrap
(() => {
    'use strict';
    const forms = document.querySelectorAll('.needs-validation');

    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }

            form.classList.add('was-validated');
        }, false);
    });
})();
</script>
</body>
</html>
